package gov.va.med.mhv.rxrefill.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="MinimumLengthValidator")
public class MinimumLengthValidator implements Validator {
	
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String MedicationName = (String) value;
				
		if (MedicationName == null || MedicationName.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}
		
		if (MedicationName.length() < 3) {
			String summary = String.format("'%s' value must be atleast 3 characters long.", MedicationName);
			String detail = "Enter a value that is at least 3 characters long.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
